/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.remotesupport.inconn;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.remotesupport.inconn.CallBackBean;
import com.ibm.hsc.remotesupport.inconn.CallBackSessionBean;
import com.ibm.hsc.remotesupport.inconn.CallBackSessionThread;
import com.ibm.hsc.remotesupport.inconn.InboundConnectivityConstants;
import com.ibm.hsc.remotesupport.inconn.InboundConnectivityTasklet;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.rcs.conndata.CecInfo;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigData;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;

public class CallBackTasklet
extends PanelTasklet
implements InboundConnectivityConstants {
    private static final String TRACE_MASKT = "JRCSCBTT";
    private static final String TRACE_MASKF = "JRCSCBTF";
    private static final String TRACE_MASKD = "JRCSCBTD";
    private static final ClassLogInfo classLogInfo = new ClassLogInfo(-88, -124, "RCS-CBakTskl");
    private CallBackBean callBackBean;
    private CallBackSessionThread cbSessionThread;

    public CallBackTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> CallBackTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> init()");
        Trace.trace((String)TRACE_MASKT, (Object)"<- init()");
    }

    public void destroy() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> destroy()");
        this.deactiviateSessionThread();
        super.destroy();
        Trace.trace((String)TRACE_MASKT, (Object)"<- destroy()");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> service(" + panelTaskletRequest + ", " + panelTaskletResponse + ")"));
        try {
            if (panelTaskletRequest.isInitialRequest()) {
                this.callBackBean = new CallBackBean();
                this.callBackBean.setBeanName("CallBackBean");
                InboundConnectivityTasklet inboundConnectivityTasklet = (InboundConnectivityTasklet)this.getParent();
                InboundConfigData inboundConfigData = inboundConnectivityTasklet.getInboundConfigData();
                this.callBackBean.setAllowUnattended(inboundConfigData.isAllowUnattendedService());
                this.callBackBean.setModemPhoneNumber(inboundConfigData.getModemPhoneNumber());
                this.callBackBean.setUnattendedDurationType(inboundConfigData.getUnattendedDurationType());
                this.callBackBean.setUnattendedAutoDays(inboundConfigData.getUnattendedAutoDays());
                this.callBackBean.setUnattendTempStarts(inboundConfigData.getUnattendedTempStart());
                this.callBackBean.setUnattendTempEnds(inboundConfigData.getUnattendedTempEnd());
                this.callBackBean.setConsoleInfo(this.createCecInfo(HMC.getHMC()));
                panelTaskletResponse.replace("com.ibm.hsc.remotesupport.inconn.res.InboundConnRes2", "CallBackPanel", (PanelBean)this.callBackBean);
            } else if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                panelTaskletResponse.terminate();
            } else {
                String string = (String)panelTaskletRequest.getData("Source");
                if (string == null) {
                    string = "";
                }
                Trace.trace((String)TRACE_MASKF, (Object)("source=" + string));
                if (string.equals("")) {
                    Trace.trace((String)TRACE_MASKF, (Object)"Unspecified source");
                    panelTaskletResponse.noAction();
                } else if (string.equals("CallBackPanel")) {
                    this.serviceCallBackPanel(panelTaskletRequest, panelTaskletResponse);
                } else if (string.equals("CallBackSessionPanel")) {
                    this.serviceCallBackSessionPanel(panelTaskletRequest, panelTaskletResponse);
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"Unknown source");
                    panelTaskletResponse.noAction();
                }
            }
        }
        catch (TaskletException taskletException) {
            throw taskletException;
        }
        catch (Exception exception) {
            throw new TaskletException((Throwable)exception);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> logException(" + throwable + ")"));
        new AusMicrocodeLog(classLogInfo, 4, throwable).writeEntry(null);
        Trace.trace((String)TRACE_MASKT, (Object)"<- logException()");
    }

    private void serviceCallBackPanel(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> serviceCallBackPanel()");
        String string = (String)panelTaskletRequest.getData("Command");
        if (string == null) {
            string = "";
        }
        Trace.trace((String)TRACE_MASKF, (Object)("command=" + string));
        if (string.equals("")) {
            Trace.trace((String)TRACE_MASKF, (Object)"Unspecified command");
            panelTaskletResponse.noAction();
        } else if (string.equals("OpenSessionPanel")) {
            CallBackSessionBean callBackSessionBean = new CallBackSessionBean();
            callBackSessionBean.setBeanName("CallBackSessionBean");
            callBackSessionBean.setConsoleInfo((CecInfo)panelTaskletRequest.getData("ConsoleInfo"));
            panelTaskletResponse.openModalChild("com.ibm.hsc.remotesupport.inconn.res.InboundConnRes2", "CallBackSessionPanel", (PanelBean)callBackSessionBean);
        } else if (string.equals("Commit")) {
            CallBackBean callBackBean = (CallBackBean)panelTaskletRequest.getData("Bean");
            if (callBackBean != null) {
                InboundConnectivityTasklet inboundConnectivityTasklet = (InboundConnectivityTasklet)this.getParent();
                InboundConfigData inboundConfigData = inboundConnectivityTasklet.getInboundConfigData();
                inboundConfigData.setAllowUnattendedService(callBackBean.isAllowUnattended());
                inboundConfigData.setModemPhoneNumber(callBackBean.getModemPhoneNumber());
                inboundConfigData.setUnattendedDurationType(callBackBean.getUnattendedDurationType());
                inboundConfigData.setUnattendedAutoDays((int)callBackBean.getUnattendedAutoDays());
                inboundConfigData.setUnattendedTempStart(callBackBean.getUnattendTempStarts());
                inboundConfigData.setUnattendedTempEnd(callBackBean.getUnattendTempEnds());
            }
            panelTaskletResponse.noAction();
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"Unknown command");
            panelTaskletResponse.noAction();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- serviceCallBackPanel()");
    }

    private void serviceCallBackSessionPanel(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> serviceCallBackSessionPanel()");
        String string = (String)panelTaskletRequest.getData("Command");
        if (string == null) {
            string = "";
        }
        Trace.trace((String)TRACE_MASKF, (Object)("command=" + string));
        if (string.equals("")) {
            Trace.trace((String)TRACE_MASKF, (Object)"Unspecified command");
            panelTaskletResponse.noAction();
        } else if (string.equals("Start")) {
            CecInfo cecInfo = (CecInfo)panelTaskletRequest.getData("ConsoleInfo");
            this.cbSessionThread = new CallBackSessionThread(this, cecInfo);
            this.cbSessionThread.start();
            panelTaskletResponse.noAction();
        } else if (string.equals("Stop")) {
            this.deactiviateSessionThread();
            panelTaskletResponse.noAction();
        } else if (string.equals("UpdateStatus")) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("Command", string);
            hashMap.put("StatusInfo", panelTaskletRequest.getData("StatusInfo"));
            panelTaskletResponse.update("CallBackSessionBean", hashMap);
        } else if (string.equals("SessionOpen")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Command", string);
            panelTaskletResponse.update("RssfSessionBean", hashMap);
        } else if (string.equals("SessionComplete")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Command", string);
            panelTaskletResponse.update("CallBackSessionBean", hashMap);
        } else if (string.equals("Cancel")) {
            panelTaskletResponse.dispose();
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"Unknown command");
            panelTaskletResponse.noAction();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- serviceCallBackSessionPanel()");
    }

    private void deactiviateSessionThread() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> deactivateSessionThread()");
        if (this.cbSessionThread != null) {
            this.cbSessionThread.cancel();
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"No session thread active");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- deactivateSessionThread()");
    }

    private CecInfo createCecInfo(HMC hMC) {
        String string = hMC.getMachineType();
        String string2 = hMC.getMachineModel();
        String string3 = hMC.getMachineSerial();
        String string4 = hMC.getName();
        ArrayList arrayList = new ArrayList();
        return new CecInfo(string, string2, string3, "HMC", arrayList);
    }
}

